package com.link.report.pojo.response;

import com.link.report.domain.entity.ExtraReportQuickbiEmbed;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * QuickBI报表嵌入信息VO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExtraReportQuickbiEmbedVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * QuickBI报表名称
     */
    private String name;

    /**
     * 报表预览访问地址
     */
    private String previewUrl;

    /**
     * QuickBI报表唯一标识ID
     */
    private String pageId;

    /**
     * 报表访问凭证（临时票据）
     */
    private String accessTicket;

    /**
     * 报表类型，如：普通报表、仪表盘、数据门户等
     */
    private String reportType;

    /**
     * 创建人（用户账号/ID）
     */
    private String createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人（用户账号/ID）
     */
    private String updateBy;

    /**
     * 更新时间（自动更新）
     */
    private LocalDateTime updateTime;


    public static ExtraReportQuickbiEmbedVo convertEntityToVo(ExtraReportQuickbiEmbed entity) {
        ExtraReportQuickbiEmbedVo vo = new ExtraReportQuickbiEmbedVo();
        vo.setId(entity.getId());
        vo.setName(entity.getName());
        vo.setPreviewUrl(entity.getPreviewUrl());
        vo.setPageId(entity.getPageId());
        vo.setAccessTicket(entity.getAccessTicket());
        vo.setReportType(entity.getReportType());
        vo.setCreateBy(entity.getCreateBy());
        vo.setCreateTime(entity.getCreateTime());
        vo.setUpdateBy(entity.getUpdateBy());
        vo.setUpdateTime(entity.getUpdateTime());
        return vo;
    }
}
