package com.link.report.pojo.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * QuickBI报表嵌入信息DTO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExtraReportQuickbiEmbedDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * QuickBI报表名称
     */
    private String name;

    /**
     * 报表预览访问地址
     */
    private String previewUrl;

    /**
     * QuickBI报表唯一标识ID
     */
    private String pageId;

    /**
     * 报表访问凭证（临时票据）
     */
    private String accessTicket;

    /**
     * 报表类型，如：普通报表、仪表盘、数据门户等
     */
    private String reportType;

    /**
     * 创建人（用户账号/ID）
     */
    private String createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人（用户账号/ID）
     */
    private String updateBy;

    /**
     * 更新时间（自动更新）
     */
    private LocalDateTime updateTime;
}
