package com.link.report.domain.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.link.report.pojo.request.ExtraReportQuickbiEmbedBo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * QuickBI报表嵌入信息表实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("extra_report_quickbi_embed")
public class ExtraReportQuickbiEmbed implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * QuickBI报表名称
     */
    private String name;

    /**
     * 报表预览访问地址
     */
    private String previewUrl;

    /**
     * QuickBI报表唯一标识ID
     */
    private String pageId;

    /**
     * 报表访问凭证（临时票据）
     */
    private String accessTicket;

    /**
     * 报表类型，如：普通报表、仪表盘、数据门户等
     */
    private String reportType;

    /**
     * 创建人（用户账号/ID）
     */
    private String createBy;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 更新人（用户账号/ID）
     */
    private String updateBy;

    /**
     * 更新时间（自动更新）
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    /**
     * 删除标识：0-未删除 1-已删除（软删除）
     */
    @TableLogic
    private Integer delFlag;

    public void create() {
    }

    public void updateFromBo(ExtraReportQuickbiEmbedBo bo) {
    }

    public void markAsDeleted() {
    }
}
