package com.link.report.controller.query;

import com.link.report.pojo.request.ExtraReportQuickbiEmbedBo;
import com.link.report.pojo.response.ExtraReportQuickbiEmbedVo;
import com.link.report.service.query.ExtraReportQuickbiEmbedService;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.controller.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.security.RolesAllowed;
import java.util.List;

/**
 * QuickBI报表嵌入信息控制器
 * @author lvbencai
 * @date 2025年12月12日
 */
@RestController
@RequestMapping("/extra/quickbi/embed")
//@Api(tags = "QuickBI报表嵌入管理")
public class ExtraReportQuickbiEmbedController extends BaseController {

    @Autowired
    private ExtraReportQuickbiEmbedService extraReportQuickbiEmbedService;

    @PostMapping
//    @ApiOperation("新增QuickBI报表嵌入信息")
    public R<ExtraReportQuickbiEmbedVo> insert(@RequestBody ExtraReportQuickbiEmbedBo bo) {
        ExtraReportQuickbiEmbedVo vo = extraReportQuickbiEmbedService.insert(bo);
        return R.ok(vo);
    }

    @PutMapping
//    @ApiOperation("更新QuickBI报表嵌入信息")
    public R<ExtraReportQuickbiEmbedVo> update(@RequestBody ExtraReportQuickbiEmbedBo bo) {
        ExtraReportQuickbiEmbedVo vo = extraReportQuickbiEmbedService.update(bo);
        return vo != null ? R.ok(vo) : R.fail("更新失败，记录不存在");
    }

    @GetMapping("/{id}")


    public R<ExtraReportQuickbiEmbedVo> getById(@PathVariable String pageId) {
        ExtraReportQuickbiEmbedVo vo = extraReportQuickbiEmbedService.getByPageId(pageId);
        return vo != null ? R.ok(vo) : R.fail("记录不存在");
    }

    @GetMapping("/page/{pageId}")
    @RolesAllowed(value = {"ROLE_ADMIN",})
    public R<ExtraReportQuickbiEmbedVo> getByPageId(@PathVariable String pageId) {
        ExtraReportQuickbiEmbedVo vo = extraReportQuickbiEmbedService.getByPageId(pageId);
        return vo != null ? R.ok(vo) : R.fail("记录不存在");
    }

    /**
     * 查询所有QuickBI报表嵌入信息列表
     * @return
     */
    @GetMapping("/list")
//    @ApiOperation("查询所有QuickBI报表嵌入信息列表")
    public R<List<ExtraReportQuickbiEmbedVo>> listAll() {
        List<ExtraReportQuickbiEmbedVo> list = extraReportQuickbiEmbedService.listAll();
        return R.ok(list);
    }

    @DeleteMapping("/{id}")
//    @ApiOperation("删除QuickBI报表嵌入信息")
    public R<Boolean> deleteById(@PathVariable Long id) {
        boolean result = extraReportQuickbiEmbedService.deleteById(id);
        return result ? R.ok(true) : R.fail("删除失败，记录不存在");
    }

    /**
     * 获取quickbi的accessTicket
     * @return accessTicket
     */
    @GetMapping("/accessTicket")
    public R<ExtraReportQuickbiEmbedVo> queryAccessTicket(String pageId) {
        return R.ok(extraReportQuickbiEmbedService.queryAccessTicket(pageId));
    }
}
