package com.link.report.controller.core;

import com.link.report.pojo.request.CustomerReportAddVo;
import com.link.report.service.query.CustomerReportService;
import com.sfa.common.core.domain.R;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe : 自定义报表管理
 */
@RestController
@RequestMapping("/customer/core")
public class CustomerReportCoreController {

    @Autowired
    CustomerReportService customerReportService;

    @RequiresPermissions("jimureport:ext:list")
    @PostMapping("/save")
    public R save(@RequestBody CustomerReportAddVo customerReportAddVo) {
        customerReportService.save(customerReportAddVo);
        return R.ok();
    }
}
