package com.link.report.config;

import com.link.report.interceptor.LoginInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig implements WebMvcConfigurer {
    // 注入Spring管理的拦截器实例（而非new MyInterceptor()）
    @Autowired
    private LoginInterceptor loginInterceptor;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(loginInterceptor)
                .addPathPatterns("/report/jmreport/shareView/**","/jmreport/shareView/**")            // 拦截所有路径
                .excludePathPatterns(             // 排除以下路径
                        "/login",                 // 登录页
                        "/doLogin",               // 登录提交接口
                        "/static/**",             // 静态资源
                        "/error"                  // 错误页
                ).order(1);
    }
}
