package com.link.report.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 报表分享
 */
@TableName(value ="jimu_report")
@Data
public class JimuReport implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private String id;

    /**
     * 编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 说明
     */
    private String note;

    /**
     * 状态
     */
    private String status;

    /**
     * 类型
     */
    private String type;

    /**
     * json字符串
     */
    private String jsonStr;

    /**
     * 请求地址
     */
    private String apiUrl;

    /**
     * 缩略图
     */
    private String thumb;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String updateBy;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 删除标识0-正常,1-已删除
     */
    private Boolean delFlag;

    /**
     * 请求方法0-get,1-post
     */
    private String apiMethod;

    /**
     * 请求编码
     */
    private String apiCode;

    /**
     * 是否是模板 0-是,1-不是
     */
    private Boolean template;

    /**
     * 浏览次数
     */
    private Long viewCount;

    /**
     * css增强
     */
    private String cssStr;

    /**
     * js增强
     */
    private String jsStr;

    /**
     * py增强
     */
    private String pyStr;

    /**
     * 多租户标识
     */
    private String tenantId;

    /**
     * 乐观锁版本
     */
    private Integer updateCount;

    /**
     * 是否填报报表 0不是,1是
     */
    private Boolean submitForm;

}
