package com.link.report.service.impl;

import com.link.report.domain.dao.ReportShareDao;
import com.link.report.domain.wq.ReportShareListWq;
import com.link.report.pojo.request.ReportShareListVo;
import com.link.report.pojo.response.ReportShareBiListDto;
import com.link.report.service.ReportShareService;
import com.sfa.common.core.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表分享数据
 */
@Service
public class ReportShareServiceImpl implements ReportShareService {
    @Autowired
    private ReportShareDao reportShareDao;

    @Override
    public List<ReportShareBiListDto> selectList(ReportShareListVo reportShareListVo) {
        ReportShareListWq wq = new ReportShareListWq();
        BeanUtils.copyProperties(reportShareListVo, wq);
        return reportShareDao.selectList(wq);
    }
}
