package com.link.report;

import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * @description: 报表中心模块
 * @author: wzlUp
 * @date: 2023/06/16 17:05
 * @motto: Done is better than perfect.
 */
@EnableCustomConfig
@Slf4j
@EnableRyFeignClients
@MapperScan(value = {"com.link.report.domain.mapper"})
@SpringBootApplication(scanBasePackages = { "com.link.report","org.jeecg","org.jeecg.modules.drag.dao"})
public class WangxiaoluLinkModuleReportApplication {

    public static void main(String[] args) {
        SpringApplication.run(WangxiaoluLinkModuleReportApplication.class, args);
        log.info(
                "  .------------------------------------. \n" +
                        " :     __                               :\n" +
                        " :  =='_))  __-:!:-                     :\n" +
                        " :    ,.' .'  ))-:!:-                   :\n" +
                        " :   ((_,'  .'-:!:-  - Report Started - :\n" +
                        " :  ~^~~~^~~^~~~^~                      :\n" +
                        "  `------------------------------------' ");
    }
}
