package com.link.report.service.query;

import com.baomidou.mybatisplus.extension.service.IService;
import com.link.report.domain.entity.ExtraReportQuickbiEmbed;
import com.link.report.pojo.request.ExtraReportQuickbiEmbedBo;
import com.link.report.pojo.response.ExtraReportQuickbiEmbedVo;

import java.util.List;

/**
 * QuickBI报表嵌入信息服务接口
 */
public interface ExtraReportQuickbiEmbedService extends IService<ExtraReportQuickbiEmbed> {

    /**
     * 新增QuickBI报表嵌入信息
     */
    ExtraReportQuickbiEmbedVo insert(ExtraReportQuickbiEmbedBo bo);

    /**
     * 更新QuickBI报表嵌入信息
     */
    ExtraReportQuickbiEmbedVo update(ExtraReportQuickbiEmbedBo bo);

    /**
     * 根据ID查询QuickBI报表嵌入信息
     */
    ExtraReportQuickbiEmbedVo getById(Long id);

    /**
     * 根据pageId查询QuickBI报表嵌入信息
     */
    ExtraReportQuickbiEmbedVo getByPageId(String pageId);

    /**
     * 查询所有QuickBI报表嵌入信息列表
     */
    List<ExtraReportQuickbiEmbedVo> listAll();

    /**
     * 删除QuickBI报表嵌入信息（软删除）
     */
    boolean deleteById(Long id);

    ExtraReportQuickbiEmbedVo queryAccessTicket(String pageId);
}
