package com.link.report.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.ExtraReportQuickbiEmbedDao;
import com.link.report.domain.entity.ExtraReportQuickbiEmbed;
import com.link.report.domain.mapper.ExtraReportQuickbiEmbedMapper;
import com.link.report.domain.wq.ExtraReportQuickbiEmbedWq;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.List;

/**
 * QuickBI报表嵌入信息 DAO层
 * 负责与数据库交互，通过mapper执行CRUD操作
 */
@Repository
public class ExtraReportQuickbiEmbedDaoImpl implements ExtraReportQuickbiEmbedDao {

    @Resource
    private ExtraReportQuickbiEmbedMapper extraReportQuickbiEmbedMapper;

    /**
     * 新增报表嵌入信息
     *
     * @param entity 报表嵌入信息实体
     * @return 影响行数
     */
    @Override
    public int insert(ExtraReportQuickbiEmbed entity) {
        return extraReportQuickbiEmbedMapper.insert(entity);
    }

    /**
     * 更新报表嵌入信息
     *
     * @param entity 报表嵌入信息实体(含更新条件)
     * @return 影响行数
     */
    @Override
    public int updateById(ExtraReportQuickbiEmbed entity) {
        return extraReportQuickbiEmbedMapper.updateById(entity);
    }

    /**
     * 根据ID查询报表嵌入信息
     *
     * @param id 主键ID
     * @return 报表嵌入信息实体
     */
    @Override
    public ExtraReportQuickbiEmbed selectById(Long id) {
        return extraReportQuickbiEmbedMapper.selectById(id);
    }

    /**
     * 根据pageId查询报表嵌入信息
     *
     * @param extraReportQuickbiEmbedWq QuickBI报表嵌入查询参数
     * @return 报表嵌入信息实体
     */
    @Override
    public ExtraReportQuickbiEmbed selectOne(ExtraReportQuickbiEmbedWq extraReportQuickbiEmbedWq) {
        LambdaQueryWrapper<ExtraReportQuickbiEmbed> queryWrapper = new LambdaQueryWrapper<ExtraReportQuickbiEmbed>();
        queryWrapper.eq(ObjectUtil.isNotEmpty(extraReportQuickbiEmbedWq.getPageId()), ExtraReportQuickbiEmbed::getPageId, extraReportQuickbiEmbedWq.getPageId());
        return extraReportQuickbiEmbedMapper.selectOne(queryWrapper);
    }

    /**
     * 查询所有报表嵌入信息
     *
     * @return 报表嵌入信息列表
     */
    @Override
    public List<ExtraReportQuickbiEmbed> selectAll() {
        return extraReportQuickbiEmbedMapper.selectList(null);
    }

    /**
     * 根据ID删除报表嵌入信息(逻辑删除)
     *
     * @param id 主键ID
     * @return 影响行数
     */
    @Override
    public int deleteById(Long id) {
        return extraReportQuickbiEmbedMapper.deleteById(id);
    }

    @Override
    public void update(ExtraReportQuickbiEmbed entity) {
        extraReportQuickbiEmbedMapper.updateById(entity);
    }
}
