package com.link.report.controller.core;

import com.link.report.pojo.request.CustomerGroupAddVo;
import com.link.report.service.core.CustomerGroupCoreService;
import com.sfa.common.core.domain.R;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe : 自定义报表管理
 */
@RestController
@RequestMapping("/customer/core")
public class CustomerGroupCoreController {

    @Autowired
    CustomerGroupCoreService groupService;

    @RequiresPermissions(logical= Logical.OR,value = {"bi:supply:list","bi:finance_report:list"})
    @PostMapping("/group/insertOrUpdate")
    public R save(@RequestBody CustomerGroupAddVo customerGroupAddVo) {
        groupService.save(customerGroupAddVo);
        return R.ok();
    }

    @RequiresPermissions(logical= Logical.OR ,value = {"bi:supply:list","bi:finance_report:list"})
    @DeleteMapping("/group/delete")
    public R delete(CustomerGroupAddVo customerGroupAddVo) {
        groupService.delete(customerGroupAddVo);
        return R.ok();
    }

    @RequiresPermissions(logical= Logical.OR ,value = {"bi:supply:list","bi:finance_report:list"})
    @GetMapping("/group/convert")
    public R convert() {
        groupService.convert();
        return R.ok();
    }
}
