package com.link.report.service.impl;

import com.link.report.domain.dao.CustomerJimuReportDao;
import com.link.report.domain.dao.ReportShareDao;
import com.link.report.domain.wq.ReportShareListWq;
import com.link.report.pojo.request.CustomerReportTransferVo;
import com.link.report.pojo.request.ReportShareListVo;
import com.link.report.pojo.response.CustomerJimuReportDto;
import com.link.report.pojo.response.ReportShareBiListDto;
import com.link.report.service.ReportShareService;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.system.api.RemoteUserService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表分享数据
 */
@Service
public class ReportShareServiceImpl implements ReportShareService {
    @Autowired
    private ReportShareDao reportShareDao;
    @Autowired
    private CustomerJimuReportDao customerJimuReportDao;
    @Autowired
    private RemoteUserService remoteUserService;

    @Override
    public List<ReportShareBiListDto> selectList(ReportShareListVo reportShareListVo) {
        ReportShareListWq wq = new ReportShareListWq();
        BeanUtils.copyProperties(reportShareListVo, wq);
        return reportShareDao.selectList(wq);
    }

    @Override
    public void transfer(CustomerReportTransferVo customerReportTransferVo) {
        // 查询当前的报表
        CustomerJimuReportDto customerJimuReportDto = customerJimuReportDao.queryByName(customerReportTransferVo.getReportName());
        R<LoginUser> userResult =remoteUserService.getUserInfo(customerReportTransferVo.getToId(), SecurityConstants.INNER) ;

        // 获取新用户的租户id
        Long deptId = userResult.getData().getSysUser().getDeptId();
        customerJimuReportDto.setTenantId(deptId.toString());

        // 修改报表
        customerJimuReportDao.updateTenentId(customerJimuReportDto);
    }
}
