package com.link.report.controller.query;

import com.link.report.pojo.request.CustomerReportQueryListVo;
import com.link.report.pojo.response.CustomerReportGroupResDto;
import com.link.report.service.CustomerReportGroupService;
import com.sfa.common.core.domain.R;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe : 自定义报表管理
 */
@RestController
@RequestMapping("/customer/query")
public class CustomerReportGroupQueryController {

    @Autowired
    CustomerReportGroupService customerReportGroupService;

    @RequiresPermissions(logical= Logical.OR ,value = {"bi:supply:list","bi:finance_report:list"})
    @GetMapping("/group/list")
    public R<List<CustomerReportGroupResDto>> queryList(CustomerReportQueryListVo vo) {
        List<CustomerReportGroupResDto> dtos =  customerReportGroupService.queryList(vo);
        return R.ok(dtos);
    }
}
