package com.link.report.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.link.report.domain.dao.CustomerReportGroupDao;
import com.link.report.domain.entity.CustomerReportGroup;
import com.link.report.pojo.request.CustomerReportGroupVo;
import com.link.report.pojo.response.CustomerReportGroupQueryListDto;
import com.link.report.pojo.response.CustomerReportGroupResDto;
import com.link.report.pojo.response.ReportItemsDto;
import com.link.report.service.CustomerReportGroupService;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 报表分享数据
 */
@Service
public class CustomerReportGroupServiceImpl implements CustomerReportGroupService  {

    @Autowired
    private CustomerReportGroupDao customerReportGroupDao;


    @Override
    public List<CustomerReportGroupResDto> queryList() {
        List<CustomerReportGroupQueryListDto>  list =  customerReportGroupDao.queryList();
        // 根据dtos 依照groupId,作为key,转换成 Map结构
         Map<String, List<CustomerReportGroupQueryListDto>> groupedMap = list.stream()
                .collect(Collectors.groupingBy(CustomerReportGroupQueryListDto::getGroupId));

        // 转换成list结构
        List<CustomerReportGroupResDto>  result = new ArrayList<>();
        for (CustomerReportGroupQueryListDto dto : list) {
            CustomerReportGroupResDto resDto = new CustomerReportGroupResDto();
            resDto.setGroupId(dto.getGroupId());
            resDto.setGroupName(dto.getGroupName());
            List<CustomerReportGroupQueryListDto> groupListDtos = groupedMap.get(dto.getGroupId());
            if(ObjectUtil.isNotEmpty(groupListDtos)){
                List<ReportItemsDto> itemsDtos = new ArrayList<>();
                // 转换成ReportShareBiListDto
                for (CustomerReportGroupQueryListDto groupListDto : groupListDtos) {
                    ReportItemsDto itemsDto = new ReportItemsDto();
                    itemsDto.setReportId(groupListDto.getReportId());
                    itemsDto.setReportName(groupListDto.getReportName());
                    itemsDto.setPreviewUrl(groupListDto.getPreviewUrl());
                    itemsDtos.add(itemsDto);
                }
                resDto.setItems(itemsDtos);
            }
            result.add(resDto);
        }
        return result;
    }

    /**
     * 新增或者修改
     * @param customerReportGroupVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void save(List<CustomerReportGroupVo> customerReportGroupVo) {
        // 新增或者修改  先删除后新增
        Long userId = SecurityUtils.getUserId();
        customerReportGroupDao.deleteByCreatorId(userId);

        // 新增
        List<CustomerReportGroup> items =  new ArrayList<>();
        for (CustomerReportGroupVo vo : customerReportGroupVo) {
            List<ReportItemsDto> itemsDtos = vo.getItems();
            for (ReportItemsDto item : itemsDtos) {
                CustomerReportGroup dto = new CustomerReportGroup();
                // 雪花算法生成id
                dto.setId(IdUtil.getSnowflakeNextIdStr());
                dto.setGroupId(vo.getId());
                dto.setReportId(item.getReportId());
                 dto.setCreateBy(String.valueOf(userId));
                dto.setTenantId(String.valueOf(userId));
                items.add(dto);
            }
        }
        customerReportGroupDao.batchInsert(items);
    }
}
