package com.link.report.service.query.impl;

import com.link.report.domain.dao.JimuReportAuthDao;
import com.link.report.domain.wq.JimuReportAuthListWq;
import com.link.report.pojo.response.JimuReportAuthListDto;
import com.link.report.service.query.JimuReportAuthQueryService;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.text.Convert;
import com.sfa.common.core.utils.ServletUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.system.api.RemoteUserService;
import com.sfa.system.api.domain.SysUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 报表授权查询数据
 */
@Service
public class JimuReportAuthQueryServiceImpl implements JimuReportAuthQueryService {
    @Autowired
    private JimuReportAuthDao authDao;
    // 远程调用查询用户列表分页信息
    @Autowired
    private RemoteUserService remoteUserService;
    /**
     * 查询授权用户列表
     *
     * @param reportId
     * @return
     */
    @Override
    public PageInfo<SysUser> selectUserList(String reportId) {
        JimuReportAuthListWq authListWq = new JimuReportAuthListWq();
        authListWq.setReportId(reportId);

        List<JimuReportAuthListDto> jimuReportListDtos = authDao.selectList(authListWq);
        if (jimuReportListDtos != null && !jimuReportListDtos.isEmpty()) {
            // 远程调用查询用户列表分页信息
            List<Long> userIds = jimuReportListDtos.stream().map(JimuReportAuthListDto::getUserId).collect(Collectors.toList());
            Integer pageNum = Convert.toInt(ServletUtils.getParameter(TableSupport.PAGE_NUM), 1);
            Integer pageSize = Convert.toInt(ServletUtils.getParameter(TableSupport.PAGE_SIZE), 10000);
            // 远程方法是分页方法，此处传默认分页数据
            R<PageInfo<SysUser>> userInfoByIds = remoteUserService.getUserInfoByIds(pageSize,pageNum, userIds,SecurityConstants.INNER);
            return userInfoByIds.getData();
        }else{
            return TableSupport.pageInfo();
        }


    }
}
