package com.link.report.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.link.report.domain.dao.JimuReportAuthDao;
import com.link.report.domain.entity.JimuReportAuth;
import com.link.report.domain.mapper.JimuReportAuthMapper;
import com.link.report.domain.wq.JimuReportAuthListWq;
import com.link.report.pojo.response.JimuReportAuthListDto;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 报表分享数据
 *
 * @author lvbencai
 * @version 1.0
 * @date 2024/6/27 15:05
 */
@Component
public class JimuReportAuthDaoImpl implements JimuReportAuthDao {
    @Autowired
    private JimuReportAuthMapper jimuReportAuthMapper;


    /**
     * 查询授权信息列表
     *
     * @param wq
     * @return
     */
    @Override
    public List<JimuReportAuthListDto> selectList(JimuReportAuthListWq wq) {
        // 查询数据
        Wrapper<JimuReportAuth> qw = new LambdaQueryWrapper<JimuReportAuth>()
                .eq(ObjectUtil.isNotEmpty(wq.getReportId()), JimuReportAuth::getReportId, wq.getReportId());
        IPage authPage = jimuReportAuthMapper.selectPage(TableSupport.pageI(), qw);
        List<JimuReportAuth> jimuReportAuths = authPage.getRecords();
        List<JimuReportAuthListDto> dtos = BeanUtils.transitionDtos(jimuReportAuths, JimuReportAuthListDto.class);
        return dtos;
    }

    @Override
    public void deleteAuthUsers(LambdaQueryWrapper wq) {
        jimuReportAuthMapper.delete(wq);
    }

    @Override
    public int insertAuthUsers(String reportId, List<Long> userIds) {
        String username = SecurityUtils.getUsername();
        return jimuReportAuthMapper.insertAuthUsers(reportId,username, userIds);
    }
}
