package com.link.report.controller.query;

import com.link.report.pojo.request.JimuReportCategoryVo;
import com.link.report.pojo.response.JimuReportCategoryDto;
import com.link.report.service.query.JimuReportCategoryQueryService;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 积木报表授权查询接口
 *
 * @author lvbencai
 * @date 2025年07月16日22:14:42
 */
@RestController
@RequestMapping("/jimuReportCategory/query")
public class JimuReportCategoryQueryController extends BaseController {

    @Autowired
    private JimuReportCategoryQueryService categoryQueryService;

    /**
     * 分页查询已授权list+自己创建的list接口
     *
     * @param categoryVo
     * @return
     */
    @GetMapping("/list")
    @RequiresPermissions(value = {"report:jimuReport:list"})
    public R<List<JimuReportCategoryDto>> selectList(JimuReportCategoryVo categoryVo) {
        List<JimuReportCategoryDto> categoryDtos = categoryQueryService.selectList(categoryVo);
         return R.ok(categoryDtos);
    }



}
