package com.link.report.service.query.impl;

import com.link.report.domain.dao.JimuReportDao;
import com.link.report.domain.wq.JimuReportListWq;
import com.link.report.pojo.request.JimuReportListVo;
import com.link.report.pojo.response.JimuReportListDto;
import com.link.report.service.query.JimuReportQueryService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表查询数据
 */
@Service
public class JimuReportQueryServiceImpl implements JimuReportQueryService {
    @Autowired
    private JimuReportDao jimuReportDao;

    /**
     * 分页查询已授权list+自己创建的list
     *
     * @param jimuReportListVo
     * @return
     */
    @Override
    public PageInfo<JimuReportListDto> selectList(JimuReportListVo jimuReportListVo) {
        PageInfo<JimuReportListDto> pageInfo = TableSupport.pageInfo();
        JimuReportListWq wq = new JimuReportListWq();
        BeanUtils.copyProperties(jimuReportListVo, wq);
        wq.setSkipNum(pageInfo.getSkipNum());
        wq.setPageSize(pageInfo.getPageSize());

        String username = SecurityUtils.getUsername();
        Long userId = SecurityUtils.getUserId();
//        admin能看到所有数据
        if(!SecurityUtils.isAdmin(userId)){
            wq.setUserName(username);
        }
        wq.setUserId(userId);

        // 查询授权报表id
        List<JimuReportListDto> list =  jimuReportDao.selectJimuReportList(wq);
        Integer count =  jimuReportDao.selectJimuReportListCount(wq);

        if (list != null && !list.isEmpty()) {
            pageInfo.setRows(list);
            pageInfo.setTotal(count);
            return  pageInfo;
        }else{
            pageInfo.setRows(list);
            pageInfo.setTotal(count);
            return  pageInfo;
        }
    }

    @Override
    public PageInfo<JimuReportListDto> selectListAll(JimuReportListVo jimuReportListVo) {
        PageInfo<JimuReportListDto> list =  jimuReportDao.selectListAll(jimuReportListVo);
        return list;
    }
}
