package com.link.report.controller.query;

import com.link.report.pojo.request.JimuReportListVo;
import com.link.report.pojo.response.JimuReportListDto;
import com.link.report.service.query.JimuReportQueryService;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 积木报表授权查询接口
 *
 * @author lvbencai
 * @date 2025年07月16日22:14:42
 */
@RestController
@RequestMapping("/jimuReport/query")
public class JimuReportQueryController extends BaseController {

    @Autowired
    private JimuReportQueryService reportQueryService;

    /**
     * 分页查询已授权list+自己创建的list接口
     *
     * @param JimuReportListVo
     * @return
     */
    @GetMapping("/list")
    @RequiresPermissions(value = {"report:jimuReport:list"})
    public R<PageInfo<JimuReportListDto>> selectList(JimuReportListVo JimuReportListVo) {
        PageInfo<JimuReportListDto> JimuReportListDtos = reportQueryService.selectList(JimuReportListVo);
         return R.ok(JimuReportListDtos);
    }


    /**
     * 分页查询所有的报表接口
     *
     * @param JimuReportListVo
     * @return
     */
    @GetMapping("/all/list")
    @RequiresPermissions(value = {"report:JimuReport:all"})
    public R<PageInfo<JimuReportListDto>> selectListAll(JimuReportListVo JimuReportListVo) {
        PageInfo<JimuReportListDto> JimuReportListDtos = reportQueryService.selectListAll(JimuReportListVo);
        return R.ok(JimuReportListDtos);
    }

}
