package com.link.report.controller.query;

import com.link.report.service.query.JimuReportAuthQueryService;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.system.api.domain.SysUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 积木报表授权查询接口
 *
 * @author lvbencai
 * @date 2025年07月16日22:14:17
 */
@RestController
@RequestMapping("/jimuReportAuth/query")
public class JimuReportAuthQueryController extends BaseController {

    @Autowired
    private JimuReportAuthQueryService authQueryService;
    /**
     * 查询授权用户列表
     *
     * @param reportId
     * @return
     */
    @GetMapping("/list/user")
    @RequiresPermissions(value = {"report:auth:userlist"})
    public R<PageInfo<SysUser>> selectUserList(String reportId) {
        PageInfo<SysUser> userPageInfo = authQueryService.selectUserList(reportId);
        return R.ok(userPageInfo);
    }

}
