package com.link.report.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 积木报表分类实体类
 */
@TableName(value ="jimu_report_category")
@Data
public class JimuReportCategory implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private String id;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 父级id
     */
    private String parentId;

    /**
     * 是否为叶子节点(0 否 1是)
     */
    private Integer izLeaf;

    /**
     * 来源类型(report 积木报表 screen 大屏 drag 仪表盘)
     */
    private String sourceType = "report";

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 删除状态(0未删除，1已删除，2临时删除)
     */
    private Integer delFlag;

    /**
     * 排序
     */
    private Integer sortNo;

}
