package com.link.report.config;

import com.alibaba.fastjson.JSONObject;
import com.sfa.common.security.service.TokenService;
import com.sfa.system.api.model.LoginUser;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *
* @ClassName: JimuInterceptor
* @Description: 监听/jmreport/view/*接口,必须携带token
* @author fzz
*
 */
@Component
@AllArgsConstructor
@Slf4j
public class JmDataScopeInterceptor implements HandlerInterceptor {
    private final TokenService tokenService;
    private final JmReportTokenServiceI jmReportTokenServiceI;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object arg2) throws Exception {
        response.setContentType("text/html; charset=UTF-8");
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String token = request.getParameter("token");
        String jmToken = request.getHeader("token");

        LoginUser loginUser = tokenService.getLoginUser(token);

        if (loginUser != null ) {
            // 数据权限
            String[] roles = jmReportTokenServiceI.getRoles(jmToken);
            if (roles.length > 0) {
                log.info(roles[0]);
             }

            return true;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 200);
        jsonObject.put("msg", "参数错误或无权访问数据");
        response.getWriter().println(jsonObject);
        return false;
    }
}
