package com.link.report;

import com.sfa.common.security.annotation.EnableCustomConfig;
import com.sfa.common.security.annotation.EnableRyFeignClients;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * @description: 报表中心模块
 * @author: wzlUp
 * @date: 2023/06/16 17:05
 * @motto: Done is better than perfect.
 */
@EnableCustomConfig
//@EnableCustomSwagger2
@EnableRyFeignClients
@MapperScan(value = {"org.jeecg.modules.jmreport.dao","com.link.report.domain.mapper"})
@SpringBootApplication(scanBasePackages = {"org.jeecg.modules.jmreport", "com.link.report"})
public class WangxiaoluLinkModuleReportApplication {

    public static void main(String[] args) {
        SpringApplication.run(WangxiaoluLinkModuleReportApplication.class, args);
        System.out.println(
                "  .------------------------------------. \n" +
                        " :     __                               :\n" +
                        " :  =='_))  __-:!:-                     :\n" +
                        " :    ,.' .'  ))-:!:-                   :\n" +
                        " :   ((_,'  .'-:!:-  - Report Started - :\n" +
                        " :  ~^~~~^~~^~~~^~                      :\n" +
                        "  `------------------------------------' ");
    }
}
