package com.link.report.controller.query;

import com.link.report.pojo.request.ReportShareListVo;
import com.link.report.pojo.response.ReportShareBiListDto;
import com.link.report.service.ReportShareService;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.datascope.annotation.DataScope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 财务分析-直播间分类基础数据
 *
 * @author admin
 * @date 2024-12-19
 */
@RestController
@RequestMapping("/customer/share")
public class ReportShareQueryController extends BaseController {

    @Autowired
    private ReportShareService reportShareService;

    /**
     * 直播间分类的页面查询
     *
     * @param reportShareListVo
     * @return
     */
    @DataScope(deptAlias = "d", userAlias = "u")
    @GetMapping("/list")
//    @RequiresPermissions("bi:supply:list")
    public R<List<ReportShareBiListDto>> selectList(ReportShareListVo reportShareListVo) {
        List<ReportShareBiListDto> reportShareBiListDtos = reportShareService.selectList(reportShareListVo);
        return R.ok(reportShareBiListDtos);
    }

}
