package com.link.report.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.link.report.domain.dao.CustomerReportDao;
import com.link.report.domain.wq.CustomerReportAddWq;
import com.link.report.domain.wq.CustomerReportQueryWq;
import com.link.report.pojo.request.CustomerReportAddVo;
import com.link.report.pojo.request.ReportShareListVo;
import com.link.report.pojo.response.CustomerReportListDto;
import com.link.report.service.CustomerReportService;
import com.sfa.common.core.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 报表分享数据
 */
@Service
public class CustomerReportServiceImpl implements CustomerReportService {

    @Autowired
    private CustomerReportDao customerReportDao;

    @Override
    public void save(CustomerReportAddVo customerReportAddVo) {
        CustomerReportAddWq wq = new CustomerReportAddWq();
        BeanUtils.copyProperties(customerReportAddVo, wq);
        if (ObjectUtil.isNotEmpty(wq.getId())) {
            customerReportDao.update(wq);
        } else {
            customerReportDao.insert(wq);
        }
    }

    @Override
    public List<CustomerReportListDto> queryCustomerReportList(ReportShareListVo reportShareListVo) {
        CustomerReportQueryWq wq = new CustomerReportQueryWq();
        wq.setCategoryName(reportShareListVo.getCategoryName());
        List<CustomerReportListDto> list = customerReportDao.queryCustomerReportList(wq);
        return list;
    }
}
