package com.link.report.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.CustomerReportGroupDao;
import com.link.report.domain.entity.CustomerReportGroup;
import com.link.report.domain.mapper.CustomerReportGroupMapper;
import com.link.report.pojo.response.CustomerReportGroupQueryListDto;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 报表分享数据
 */
@Component
public class CustomerReportGroupDaoImpl implements CustomerReportGroupDao {
    @Autowired
    private CustomerReportGroupMapper reportGroupMapper;
    @Override
    public List<CustomerReportGroup> list() {
        // 更加登录人id查询
        List<CustomerReportGroup> list = reportGroupMapper.selectList(new LambdaQueryWrapper<>());
        return list;
    }
    @Override
    public List<CustomerReportGroupQueryListDto> queryList() {
        Long userId = SecurityUtils.getUserId();
        // 更加登录人id查询
        List<CustomerReportGroupQueryListDto> list = reportGroupMapper.queryReportGroupList(userId);
        return list;
    }

    @Override
    public void deleteByCreatorId(Long userId) {
        reportGroupMapper.delete(new LambdaQueryWrapper<CustomerReportGroup>()
                .eq(CustomerReportGroup::getCreateUserId, userId));
    }

    @Override
    public void batchInsert(List<CustomerReportGroup> items) {
        reportGroupMapper.batchInsert(items);
    }

    @Override
    public void update(CustomerReportGroup customerReportGroup) {
        reportGroupMapper.updateById(customerReportGroup);
    }
}
