package com.link.report.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.JimuReportCategoryQueryDao;
import com.link.report.domain.entity.JimuReportCategory;
import com.link.report.domain.mapper.JimuReportCategoryMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 报表分享数据
 * @author lvbencai
 * @version 1.0
 * @date 2024/6/27 15:05
 */
@Component
public class JimuReportCategoryQueryDaoImpl implements JimuReportCategoryQueryDao {
      @Autowired
    private JimuReportCategoryMapper jimuReportCategoryMapper;


    @Override
    public List<JimuReportCategory> queryList(JimuReportCategory category) {
        Wrapper<JimuReportCategory> wq  = new LambdaQueryWrapper<JimuReportCategory>()
                .eq(ObjectUtil.isNotEmpty(category.getId()), JimuReportCategory::getId, category.getId());
        List<JimuReportCategory> jimuReportCategories = jimuReportCategoryMapper.selectList(wq);
        return jimuReportCategories;
    }
}
