package com.link.report.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.link.report.domain.dao.CustomerGroupDao;
import com.link.report.domain.dao.CustomerReportGroupDao;
import com.link.report.domain.entity.CustomerReportGroup;
import com.link.report.domain.wq.CustomerGroupQueryWq;
import com.link.report.pojo.request.CustomerGroupAddVo;
import com.link.report.pojo.response.CustomerGroupDto;
import com.link.report.service.CustomerGroupService;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.domain.R;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.system.api.RemoteUserService;
import com.sfa.system.api.domain.SysUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 报表分享数据
 */
@Service
public class CustomerGroupServiceImpl implements CustomerGroupService {

    @Autowired
    private CustomerGroupDao groupDao;
    @Autowired
    private CustomerReportGroupDao reportGroupDao;
    @Autowired
    private RemoteUserService remoteUserService;

    @Override
    public void save(CustomerGroupAddVo customerReportAddVo) {
       Long userId = SecurityUtils.getUserId();
       String  userName = SecurityUtils.getUsername();
        customerReportAddVo.setCreateBy(userName);
        customerReportAddVo.setCreateUserId(userId);
        customerReportAddVo.setUpdateBy(userName);
        customerReportAddVo.setUpdateUserId(userId);
        if (ObjectUtil.isNotEmpty(customerReportAddVo.getGroupId())) {
            groupDao.update(customerReportAddVo);
        } else {
            groupDao.insert(customerReportAddVo);
        }
    }

    @Override
    public void delete(CustomerGroupAddVo customerReportAddVo) {
        groupDao.delete(customerReportAddVo.getGroupId());
    }

    @Override
    public void convert() {
        // 查询出当前有多少关联分组的
        List<CustomerReportGroup> list = reportGroupDao.list();
        List<String> groupIds = list.stream().map(CustomerReportGroup::getGroupId).collect(Collectors.toList());
        // 根据groupIds
        CustomerGroupQueryWq wq = new CustomerGroupQueryWq();
        wq.setGroupIds(groupIds);
        List<CustomerGroupDto> groupDtos = groupDao.queryList(wq);
//        转成map key 为groupid value 为CustomerGroupDto对象
        Map<String, CustomerGroupDto> dtoMap = groupDtos.stream().collect(Collectors.toMap(CustomerGroupDto::getGroupId, item -> item));
        // 创建 不同人的分组信息
        for (int i = 0; i < list.size(); i++) {
            //获取组id
            CustomerReportGroup customerReportGroup = list.get(i);
            String groupId = customerReportGroup.getGroupId();
            // groupDtos中找到匹配的数据
            CustomerGroupDto customerGroupDto = dtoMap.get(groupId);
            if (ObjectUtil.isNotEmpty(customerGroupDto)) {


                // 匹配到了
                CustomerGroupAddVo groupAddVo = new CustomerGroupAddVo();
                // 分组
                groupAddVo.setCategoryName(customerGroupDto.getCategoryName());
                groupAddVo.setGroupName(customerGroupDto.getGroupName());
                R<SysUser> userResult =remoteUserService.getUserInfoById(Long.valueOf(customerReportGroup.getCreateBy()), SecurityConstants.INNER) ;

                Long userid = userResult.getData().getUserId();
                String  userName = userResult.getData().getUserName();

                CustomerGroupQueryWq groupQueryWq = new CustomerGroupQueryWq();
                groupQueryWq.setCreateUserId(userid);
                groupQueryWq.setName(customerGroupDto.getGroupName());
                List<CustomerGroupDto> existGroupDtos = groupDao.queryList(groupQueryWq);
                if (ObjectUtil.isEmpty(existGroupDtos)) {
                    groupAddVo.setGroupId(IdUtil.getSnowflakeNextIdStr());
                    groupAddVo.setCreateUserId(userid);
                    groupAddVo.setUpdateUserId(userid);
                    groupAddVo.setCreateBy(userName);
                    groupAddVo.setUpdateBy(userName);
                    groupDao.insert(groupAddVo);
                    customerReportGroup.setGroupId(groupAddVo.getGroupId());

                }else{
                    CustomerGroupDto existGroupDto = existGroupDtos.get(0);
                    customerReportGroup.setGroupId(existGroupDto.getGroupId());
                }

                // 修改数据
                customerReportGroup.setCreateBy(userName);
                customerReportGroup.setUpdateBy(userName);
                customerReportGroup.setCreateUserId(userid);
                customerReportGroup.setUpdateUserId(userid);
                customerReportGroup.setUpdateTime(new Date());
                // 更新 分组id
                reportGroupDao.update(customerReportGroup);
            }
        }
    }
}
