package com.link.report.service.core.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.JimuReportAuthDao;
import com.link.report.domain.dao.JimuReportDao;
import com.link.report.domain.entity.JimuReport;
import com.link.report.domain.entity.JimuReportAuth;
import com.link.report.service.core.JimuReportAuthCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 积木报授权信息Service业务层处理
 *
 * @author admin
 * @date 2025-07-16
 */
@Service
public class JimuReportAuthCoreServiceImpl implements JimuReportAuthCoreService {
    @Autowired
    private JimuReportAuthDao jimuReportAuthDao;
    @Autowired
    private JimuReportDao jimuReportDao;


    /**
     * 批量授权用户信息
     * @param reportId
     * @param userIds
     * @return
     */
    @Override
    public int insertAuthUsers(String reportId, List<Long> userIds) {
        // 校验报表 是否存在
        checkReportExist(reportId);
        // 校验用户是否存在
//        checkUserExist(userIds);
        LambdaQueryWrapper deleteWq = new LambdaQueryWrapper<JimuReportAuth>() .eq(JimuReportAuth::getReportId, reportId);

        // 删除原有的授权信息
        jimuReportAuthDao.deleteAuthUsers(deleteWq);
        // 插入新的授权信息
        if (userIds != null && userIds.size() > 0) {
          return  jimuReportAuthDao.insertAuthUsers(reportId, userIds);
        }
        return 0;
    }

    /**
     * 校验报表是否存在
     * @param reportId
     */
    private void checkReportExist(String reportId) {
        if (reportId == null) {
            throw new RuntimeException("报表ID不能为空");
        }
        //查询
        JimuReport jimuReport = jimuReportDao.selectById(reportId);
        if (jimuReport == null) {
            throw new RuntimeException("报表不存在");
        }
    }


}
