package com.link.report.service.impl;

import cn.hutool.core.util.IdUtil;
import com.link.report.domain.dao.CustomerGroupDao;
import com.link.report.domain.dao.CustomerReportGroupDao;
import com.link.report.domain.entity.CustomerReportGroup;
import com.link.report.domain.wq.CustomerGroupQueryWq;
import com.link.report.pojo.request.CustomerReportGroupVo;
import com.link.report.pojo.request.CustomerReportQueryListVo;
import com.link.report.pojo.response.CustomerGroupDto;
import com.link.report.pojo.response.CustomerReportGroupQueryListDto;
import com.link.report.pojo.response.CustomerReportGroupResDto;
import com.link.report.pojo.response.ReportItemsDto;
import com.link.report.service.CustomerReportGroupService;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 报表分享数据
 */
@Service
public class CustomerReportGroupServiceImpl implements CustomerReportGroupService {

    @Autowired
    private CustomerReportGroupDao customerReportGroupDao;

    @Autowired
    private CustomerGroupDao customerGroupDao;

    @Override
    public List<CustomerReportGroupResDto> queryList(CustomerReportQueryListVo vo) {
        CustomerGroupQueryWq wq = new CustomerGroupQueryWq();
        wq.setCategoryName(vo.getCategoryName());
        // 先查询分组
        List<CustomerGroupDto> groupDtos = customerGroupDao.queryList(wq);
        List<CustomerReportGroupQueryListDto> list = customerReportGroupDao.queryList();
        // 转换成list结构
        List<CustomerReportGroupResDto> result = new ArrayList<>();
        for (CustomerGroupDto dto : groupDtos) {
            // 先看分组
            CustomerReportGroupResDto resDto = new CustomerReportGroupResDto();
            resDto.setGroupId(dto.getGroupId());
            resDto.setGroupName(dto.getGroupName());
            List<ReportItemsDto> itemsDtos = new ArrayList<>();
            // 在看报表
            for (CustomerReportGroupQueryListDto reportGroupQueryListDto : list) {
                if (reportGroupQueryListDto.getGroupId().equals(dto.getGroupId())) {
                    // 转换成ReportShareBiListDto
                    ReportItemsDto itemsDto = new ReportItemsDto();
                    itemsDto.setReportId(reportGroupQueryListDto.getReportId());
                    itemsDto.setReportName(reportGroupQueryListDto.getReportName());
                    itemsDto.setPreviewUrl(reportGroupQueryListDto.getPreviewUrl());
                    itemsDtos.add(itemsDto);
                }
            }
            resDto.setItems(itemsDtos);
            result.add(resDto);
        }


        return result;
    }

    /**
     * 新增或者修改
     *
     * @param customerReportGroupVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void save(List<CustomerReportGroupVo> customerReportGroupVo) {
        // 新增或者修改  先删除后新增
        Long userId = SecurityUtils.getUserId();
        customerReportGroupDao.deleteByCreatorId(userId);

        // 新增
        List<CustomerReportGroup> items = new ArrayList<>();
        for (CustomerReportGroupVo vo : customerReportGroupVo) {
            List<ReportItemsDto> itemsDtos = vo.getItems();
            for (ReportItemsDto item : itemsDtos) {
                CustomerReportGroup dto = new CustomerReportGroup();
                // 雪花算法生成id
                dto.setId(IdUtil.getSnowflakeNextIdStr());
                dto.setGroupId(vo.getId());
                dto.setReportId(item.getReportId());
                dto.setReportType(item.getReportType());
                dto.setCreateBy(String.valueOf(userId));
                dto.setTenantId(String.valueOf(userId));
                items.add(dto);
            }
        }
        customerReportGroupDao.batchInsert(items);
    }
}
