package com.link.report.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.CustomerGroupDao;
import com.link.report.domain.entity.CustomerGroup;
import com.link.report.domain.mapper.CustomerGroupMapper;
import com.link.report.domain.wq.CustomerGroupQueryWq;
import com.link.report.pojo.response.CustomerGroupDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 报表分享数据
 */
@Component
public class CustomerGroupDaoImpl implements CustomerGroupDao {
    @Autowired
    private CustomerGroupMapper groupMapper;


    @Override
    public List<CustomerGroupDto> queryList(CustomerGroupQueryWq wq) {

        Wrapper<CustomerGroup> wraper = new LambdaQueryWrapper<CustomerGroup>()
                .eq(ObjectUtil.isNotEmpty(wq.getCategoryName()), CustomerGroup::getCategoryName, wq.getCategoryName());
        List<CustomerGroup> customerGroups = groupMapper.selectList(wraper);
        List<CustomerGroupDto> result = new ArrayList<>();
        for (CustomerGroup customerGroup : customerGroups) {
            CustomerGroupDto dto = new CustomerGroupDto();
            dto.setGroupId(customerGroup.getId());
            dto.setGroupName(customerGroup.getName());
            dto.setCatalogName(customerGroup.getCategoryName());
            result.add(dto);
        }
        return result;
    }
}
