package com.link.report.controller.query;

import com.link.report.pojo.response.CustomerReportListDto;
import com.link.report.service.CustomerReportService;
import com.sfa.common.core.domain.R;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe : 自定义报表管理
 */
@RestController
@RequestMapping("/customer/query")
public class CustomerReportQueryController {

    @Autowired
    CustomerReportService customerReportService;

    @RequiresPermissions("bi:supply:list")
    @GetMapping("/list")
    public R<List<CustomerReportListDto>> queryList() {
        List<CustomerReportListDto> customerReportListDtos = customerReportService.queryCustomerReportList();
        return R.ok(customerReportListDtos);
    }
}
