package com.link.report.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.link.report.domain.dao.JimuReportDao;
import com.link.report.domain.entity.JimuReport;
import com.link.report.domain.entity.JimuReportCategory;
import com.link.report.domain.mapper.JimuReportCategoryMapper;
import com.link.report.domain.mapper.JimuReportMapper;
import com.link.report.domain.wq.JimuReportListWq;
import com.link.report.pojo.response.JimuReportListDto;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 报表分享数据
 * @author lvbencai
 * @version 1.0
 * @date 2024/6/27 15:05
 */
@Component
public class JimuReportDaoImpl implements JimuReportDao {
    @Autowired
    private JimuReportMapper jimuReportMapper;
    @Autowired
    private JimuReportCategoryMapper jimuReportCategoryMapper;


    /**
     * 查询报表列表
     * 查询有权限的报表数据：根据分配的报表数据 + 自己的报表数据
     * @param jimuReportListWq
     * @return
     */
    @Override
    public List<JimuReportListDto> selectJimuReportList(JimuReportListWq jimuReportListWq) {
        // 查询数据
        List<JimuReportListDto> jimuReportListDtos = jimuReportMapper.selectJimuReportList(jimuReportListWq);
        return jimuReportListDtos;
    }

    @Override
    public Integer selectJimuReportListCount(JimuReportListWq wq) {
        return jimuReportMapper.selectJimuReportListCount(wq);
    }

    @Override
    public PageInfo<JimuReportListDto> selectListAll(JimuReportListWq wq) {

        LambdaQueryWrapper<JimuReport> qw = new LambdaQueryWrapper<JimuReport>()
                .eq(JimuReport::getDelFlag,0)
                 .eq(ObjectUtil.isNotEmpty(wq.getCategory()) && !StringUtils.equals(wq.getCategory(),"0"),JimuReport::getType,wq.getCategory())
                .like(ObjectUtil.isNotEmpty(wq.getName()),JimuReport::getName,wq.getName());

        IPage<JimuReport> jimuReportPage = jimuReportMapper.selectPage(TableSupport.pageI(), qw);
        // 转换成DTO 增加目录查询
        List<JimuReportListDto> jimuReportListDtos = new ArrayList<>();
        for (JimuReport jimuReport : jimuReportPage.getRecords()) {
            JimuReportListDto jimuReportListDto = new JimuReportListDto();
            BeanUtils.copyProperties(jimuReport,jimuReportListDto);
            // 根据type查询 目录名称
            JimuReportCategory jimuReportCategory = jimuReportCategoryMapper.selectById(jimuReport.getType());
            if(ObjectUtil.isEmpty(jimuReportCategory)){
                jimuReportListDto.setCategory("0");
                jimuReportListDto.setCategoryName("文件夹");
            }else{
                jimuReportListDto.setCategory(jimuReportCategory.getId());
                jimuReportListDto.setCategoryName(jimuReportCategory.getName());
            }

            jimuReportListDtos.add(jimuReportListDto);
        }

       PageInfo<JimuReportListDto>  pageInfo = new PageInfo<JimuReportListDto>();
        pageInfo.setRows(jimuReportListDtos);
        pageInfo.setTotal((int) jimuReportPage.getTotal());
        pageInfo.setPageNum((int) jimuReportPage.getCurrent());
        pageInfo.setPageSize((int) jimuReportPage.getSize());
        return pageInfo;
    }

    @Override
    public JimuReport selectById(String reportId) {
        return jimuReportMapper.selectById(reportId);
    }


}
