package com.link.report.controller.core;

import com.link.report.pojo.request.JimuReportAuthAddVo;
import com.link.report.service.core.JimuReportAuthCoreService;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 财务分析-直播间分类基础数据
 *
 * @author admin
 * @date 2024-12-19
 */
@RestController
@RequestMapping("/jimuReportAuth/core")
public class JimuReportAuthCoreController extends BaseController {


    @Autowired
    private JimuReportAuthCoreService jimuReportAuthCoreService;

    /**
     * 批量选择用户授权
     */
    @RequiresPermissions("report:jimuReport:authUsers")
    @Log(title = "报表权限管理", businessType = BusinessType.GRANT)
    @PutMapping("/authUsers")
    public R selectAuthUserAll(@RequestBody JimuReportAuthAddVo vo) {
        return  R.ok(jimuReportAuthCoreService.insertAuthUsers(vo.getReportId(), vo.getUserIds()));
    }

}
