package com.link.report.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.report.domain.dao.CustomerReportDao;
import com.link.report.domain.entity.CustomerReport;
import com.link.report.domain.mapper.CustomerReportMapper;
import com.link.report.domain.wq.CustomerReportQueryWq;
import com.link.report.pojo.response.CustomerReportListDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 报表分享数据
 */
@Component
public class CustomerReportDaoImpl implements CustomerReportDao {
    @Autowired
    private CustomerReportMapper customerReportMapper;

    @Override
    public void insert(CustomerReport report) {
        customerReportMapper.insert(report);
    }

    @Override
    public void update(CustomerReport report) {
        customerReportMapper.updateById(report);
    }

    @Override
    public List<CustomerReportListDto> queryCustomerReportList(CustomerReportQueryWq wq) {
        Wrapper<CustomerReport> qw = new LambdaQueryWrapper<CustomerReport>()
                .eq(ObjectUtil.isNotEmpty(wq.getCategoryName()),CustomerReport::getCategoryName, wq.getCategoryName());
        // 按照条件查询
        List<CustomerReport> customerReports = customerReportMapper.selectList(qw);
        List<CustomerReportListDto> list = new ArrayList<>();
        for (CustomerReport customerReport : customerReports) {
            CustomerReportListDto dto = new CustomerReportListDto();
            dto.setReportId(customerReport.getId());
            dto.setReportName(customerReport.getName());
            dto.setReportType(customerReport.getReportType());
            dto.setPreviewUrl(customerReport.getPreviewUrl());
            list.add(dto);
        }
        return list;
    }
}
