package com.link.report.controller.core;

import com.link.report.pojo.request.CustomerReportGroupVo;
import com.link.report.service.query.CustomerReportGroupService;
import com.sfa.common.core.domain.R;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe : 自定义报表管理
 */
@RestController
@RequestMapping("/customer/core")
public class CustomerReportGroupCoreController {

    @Autowired
    CustomerReportGroupService customerReportGroupService;

    @RequiresPermissions(logical= Logical.OR ,value = {"bi:supply:list","bi:finance_report:list"})
    @PostMapping("/group/save")
    public R insertOrUpdate(@RequestBody List<CustomerReportGroupVo> vos) {
        customerReportGroupService.save(vos);
        return R.ok();
    }
}
