package com.link.hub.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.link.hub.pojo.oa.dto.WechatOaUserDto;
import com.link.hub.pojo.oa.dto.WechatOaUserResDto;
import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.core.utils.SpringUtils;
import com.sfa.common.redis.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author : liqiulin
 *Coate : 2024-04-15 15
 * @describe :
 */
@Slf4j
@Component
public class WeChatPlatFormUtils {
    // 微信模板消息接口地址
    private static final String TEMPLATE_SEND_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send";
    private static final String MINI_PROGRAM_CODE2SESSION_URL = "https://api.weixin.qq.com/sns/jscode2session";

    private static final String ACCESS_TOKEN_URL =  "https://api.weixin.qq.com/cgi-bin/token";
    private static final String STABLE_ACCESS_TOKEN_URL =  "https://api.weixin.qq.com/cgi-bin/stable_token";
    private static String BATCH_USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info/batchget";

    public static Object isSubscribe(String openId, String templateId, String accessToken) {
        String url = TEMPLATE_SEND_URL + "?access_token=" + accessToken;

        // 构造一个无效的模板消息内容
        String jsonBody = String.format(
                "{\"touser\":\"%s\",\"template_id\":\"%s\",\"data\":{\"keyword1\":{\"value\":\"test\"}}}",
                openId, templateId
        );

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(new StringEntity(jsonBody, "UTF-8"));
            httpPost.setHeader("Content-type", "application/json");

            try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
                String result = EntityUtils.toString(response.getEntity(), "UTF-8");
                JSONObject jsonObject = JSON.parseObject(result);
                log.info("result: {}", jsonObject.toString());
                Integer errCode = jsonObject.getInteger("errcode");
                log.info("errCode: {}", errCode);
                // 根据错误码判断
                if (errCode != null) {
                    return errCode != 43004;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取"+templateId+"是否订阅"+openId+"失败"+e.getMessage(), e);
        }
        return false;
    }

    /**
     * 服务号、小程序获取access_token
     * @param appId
     * @param appSecret
     * @return
     */
    public static String getMiniappAccessToken(String appId, String appSecret) {
        String cacheKey = "hub:wx_access_token_" + appId;
        Object accessToken = SpringUtils.getBean(RedisService.class).getCacheObject(cacheKey);
        if (accessToken != null) {
            return accessToken.toString();
        }

        String url = ACCESS_TOKEN_URL +"?grant_type=client_credential&appid=" + appId + "&secret=" + appSecret;
        String body = HttpUtil.createGet(url).execute().body();
        JSONObject jsonObject = JSONObject.parseObject(body);
        String accessTokenNew = jsonObject.getString("access_token");

        // 缓存到redis
        SpringUtils.getBean(RedisService.class).setCacheObject(cacheKey, accessTokenNew, 7000L, TimeUnit.SECONDS);

        return accessTokenNew;
    }


    /**
     * 服务号、小程序获取access_token
     * @param appId
     * @param appSecret
     * @return
     */
    public static String  getStableAccessToken(String appId, String appSecret) {
        String cacheKey = "hub:wx_access_token_" + appId;
        Object cacheObject = SpringUtils.getBean(RedisService.class).getCacheObject(cacheKey);
        if (cacheObject != null) {
            return cacheObject.toString();
        }
//        String url = STABLE_ACCESS_TOKEN_URL +"?grant_type=client_credential&appid=" + appId + "&secret=" + appSecret;
        String url = STABLE_ACCESS_TOKEN_URL  ;
        // 构造请求体参数（JSON 格式）
        JSONObject param = new JSONObject();
        param.put("grant_type", "client_credential");
        param.put("appid", appId);
        param.put("secret", appSecret);


        String body = HttpUtil.createPost(url).body(param.toJSONString()).execute().body();
        JSONObject jsonObject = JSONObject.parseObject(body);
        String accessToken = jsonObject.getString("access_token");

        if(accessToken == null){
            throw  new ServiceException("获取用户列表失败");
        }
        // 缓存到redis
        SpringUtils.getBean(RedisService.class).setCacheObject(cacheKey, accessToken, 7000L, TimeUnit.SECONDS);

        return accessToken;
    }


    /**
     * 服务号批量获取用户基本信息 batchUserinfo
     * POST https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=ACCESS_TOKEN
     * @param userDtos
     * @param appId
     * @param appSecret
     * @return
     */
    public static List<WechatOaUserResDto> getUserInfoBatch(List<WechatOaUserDto> userDtos, String appId, String appSecret) {
        String url = BATCH_USER_INFO_URL+"?access_token=" + getMiniappAccessToken(appId, appSecret);
        JSONObject param = new JSONObject();
        param.put("user_list", userDtos);
        String body = HttpUtil.createPost(url).body(param.toString()).execute().body();

        JSONObject jsonObject = JSONObject.parseObject(body);
        if(jsonObject.getInteger("errcode") != null){
            throw  new ServiceException("获取用户列表失败");
        }
        List<WechatOaUserResDto> userInfoList = jsonObject.getList("user_info_list", WechatOaUserResDto.class);
        return userInfoList;
    }

    public JSONObject getUserPhoneByAccessToken(String accessToken, String code) {
        JSONObject param = new JSONObject();
        param.put("code", code);
        String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + accessToken;
        String body = HttpUtil.createPost(url).body(param.toString()).execute().body();
        return JSONObject.parseObject(body);
    }

    public static JSONObject getOpenid(String jsCode, String xltAppId, String xltAppSecret) {
        String url = MINI_PROGRAM_CODE2SESSION_URL +"?appid=" + xltAppId + "&secret=" + xltAppSecret + "&js_code=" + jsCode + "&grant_type=authorization_code";
        String body = HttpUtil.createGet(url).execute().body();
        return JSONObject.parseObject(body);
    }
}
