package com.link.hub.domain.weChatOfficialAccount.mapper;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.link.hub.domain.weChatOfficialAccount.entity.WechatOfficialAccountUser;
import org.apache.ibatis.annotations.Mapper;

/**
 * 微信公众号用户 Mapper 接口
 */
@Mapper
public interface WechatOfficialAccountUserMapper extends BaseMapper<WechatOfficialAccountUser> {
    /**
     * 根据 openId 查询用户
     * @param openId 公众号用户唯一标识
     * @return 用户实体
     */
    default WechatOfficialAccountUser selectByOpenId(String openId) {
        return selectOne(new LambdaQueryWrapper<WechatOfficialAccountUser>()
                .eq(WechatOfficialAccountUser::getOpenid, openId));
    }
}
