package com.link.hub.domain.weChatMiniProgram.enums;

public enum SourceEnum {
    WECHAT_MINI_PROGRAM(1,"微信小程序"),
    DOUYIN_MINI_PROGRAM(2,"抖音小程序");
    private Integer code;
    private String desc;
    SourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getSourceName(Integer source) {
        for (SourceEnum value : SourceEnum.values()) {
            if (value.code.equals(source)) {
                return value.desc;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }
    public String getDesc() {
        return desc;
    }
}
