package com.link.hub.domain.weChatMiniProgram.entity;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.annotation.*;
import com.link.hub.pojo.mp.dto.MpOpenIdDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信小程序用户表 POJO/PO
 * 对应表：wechat_mini_program_user
 */
@Data
@TableName("wechat_mini_program_user")
public class WechatMiniProgramUser implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 小程序用户唯一标识
     */
    @TableField("openid")
    private String openid;

    /**
     * 微信开放平台统一标识
     */
    @TableField("unionid")
    private String unionid;

    /**
     * 用户昵称
     */
    @TableField("nickname")
    private String nickname;

    /**
     * 用户头像URL
     */
    @TableField("avatar_url")
    private String avatarUrl;

    /**
     * 性别：0-未知，1-男，2-女
     */
    @TableField("sex")
    private Integer sex;

    /**
     * 用户手机号（脱敏存储）
     */
    @TableField("phone")
    private String phone;

    /**
     * 用户所在国家
     */
    @TableField("country")
    private String country;

    /**
     * 用户所在省份
     */
    @TableField("province")
    private String province;

    /**
     * 用户所在城市
     */
    @TableField("city")
    private String city;

    /**
     * 用户首次进入小程序时间
     */
    @TableField("register_time")
    private Date registerTime;

    /**
     * 用户最后登录小程序时间
     */
    @TableField("last_login_time")
    private Date lastLoginTime;

    /**
     * 是否禁用：0-正常，1-禁用
     */
    @TableField("is_disabled")
    private Integer isDisabled;

    /**
     * 记录创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 记录更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    public static WechatMiniProgramUser create(MpOpenIdDTO mpOpenIdDTO) {

        WechatMiniProgramUser wechatMiniProgramUser = new WechatMiniProgramUser();
        wechatMiniProgramUser.setOpenid(mpOpenIdDTO.getOpenid());
        wechatMiniProgramUser.setUnionid(mpOpenIdDTO.getUnionid());
        wechatMiniProgramUser.setNickname(mpOpenIdDTO.getNickname());
        wechatMiniProgramUser.setAvatarUrl(mpOpenIdDTO.getAvatarUrl());
         wechatMiniProgramUser.setLastLoginTime(DateUtil.date());
         wechatMiniProgramUser.setCreateTime(DateUtil.date());
        wechatMiniProgramUser.setUpdateTime(DateUtil.date());
        return wechatMiniProgramUser;
    }
}
