package com.link.hub.controller.oa.query;

import com.link.hub.service.officeAccount.WechatOfficeAccountService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 微信公众号
 */
@RestController
@RequestMapping("/oa")
public class WeChatOaController {

    @Resource
    private WechatOfficeAccountService weChatOaService;

    @RequestMapping("/query/list")
    public List<String> list(String nextOpenId) {
        List<String> userList = weChatOaService.getUserList(nextOpenId);
        return userList;
    }

    /**
     * 保存用户列表
     */
    @PostMapping("/saveBatch/UserList")
    public String saveUserList() {
        Integer count = weChatOaService.saveUserList();
        return "保存用户列表成功:" + count;
    }


    @PostMapping("/saveBatch/detail")
    public String saveUserDetail(Integer pageNum, Integer pageSize) {
        weChatOaService.saveUserDetail(pageNum, pageSize);
        return "查询并保存用户详情成功";

    }
    @PostMapping("/saveAllBatch/detail")
    public String saveAllUserDetail() {
        weChatOaService.saveAllUserDetail();
        return "查询并保存用户详情成功";

    }
}
