// 包路径：com.link.hub.application.service.impl
package com.link.hub.service.officeAccount.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatOfficialAccount.dao.WechatOfficialAccountUserDao;
import com.link.hub.domain.weChatOfficialAccount.entity.WechatOfficialAccountUser;
import com.link.hub.domain.weChatOfficialAccount.mapper.WechatOfficialAccountUserMapper;
import com.link.hub.domain.weChatOfficialAccount.mq.WeChatOaUserQueryWq;
import com.link.hub.pojo.oa.dto.WeChatOaUserQueryDto;
import com.link.hub.pojo.oa.dto.WechatOaUserDto;
import com.link.hub.pojo.oa.dto.WechatOaUserResDto;
import com.link.hub.service.officeAccount.WechatOfficialAccountUserService;
import com.sfa.common.core.web.domain.PageInfo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 微信公众号用户 服务实现类
 */
@Service
public class WechatOfficialAccountUserServiceImpl
        extends ServiceImpl<WechatOfficialAccountUserMapper, WechatOfficialAccountUser>
        implements WechatOfficialAccountUserService {

    @Resource
    private WechatOfficialAccountUserDao dao;

    @Override
    public WechatOfficialAccountUser getUserByOpenId(String openId) {
        return getBaseMapper().selectByOpenId(openId);
    }

    @Override
    public boolean saveOrUpdateUser(WechatOfficialAccountUser user) {
        // 可添加业务校验逻辑
        return super.saveOrUpdate(user);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveOrUpdateBatch(List<WechatOaUserDto> officialAccountUsers) {
        if (officialAccountUsers.isEmpty()) {
            return;
        }

        // 收集所有 openId
        Set<String> allOpenIds = officialAccountUsers.stream()
                .filter(user -> user.getOpenid() != null)
                .map(WechatOaUserDto::getOpenid)
                .collect(Collectors.toSet());

        // 批量查询已存在的 openId
        List<WechatOfficialAccountUser> existingUsers = dao.selectByOpenIds(allOpenIds);
        Set<String> existingOpenIds = existingUsers.stream()
                .map(WechatOfficialAccountUser::getOpenid)
                .collect(Collectors.toSet());

        // 分组：需更新 & 需新增
        List<WechatOaUserDto> usersToUpdates = officialAccountUsers.stream()
                .filter(user -> existingOpenIds.contains(user.getOpenid()))
                .collect(Collectors.toList());

        List<WechatOaUserDto> usersToSaves = officialAccountUsers.stream()
                .filter(user -> !existingOpenIds.contains(user.getOpenid()))
                .collect(Collectors.toList());

        // 批量操作
        if (!usersToUpdates.isEmpty()) {
            dao.updateBatch(usersToUpdates);
        }
        if (!usersToSaves.isEmpty()) {
            dao.saveBatch(usersToSaves);
        }
    }

    @Override
    public WechatOfficialAccountUser selectMaxIdUser() {

        List<WechatOfficialAccountUser> officialAccountUsers = dao.selectList();
        if(officialAccountUsers.isEmpty()){
           return null;
        }
        return officialAccountUsers.get(0);
    }

    @Override
    public List<WechatOaUserDto> selectPageList(Integer pageNum, Integer pageSize) {
        PageInfo<WechatOfficialAccountUser> officialAccountUsers = dao.selectPageList(pageNum, pageSize);
        List<WechatOaUserDto> wechatOaUserDtos = officialAccountUsers.getRows().stream()
                .map(user -> {
                    WechatOaUserDto dto = new WechatOaUserDto();
                    dto.setOpenid(user.getOpenid());
                    dto.setLanguage(user.getLanguage());
                    return dto;
                })
                .collect(Collectors.toList());
        return  wechatOaUserDtos;
    }

    @Override
    public void updateUserInfoBatch(List<WechatOaUserResDto> userInfoBatch) {
        if (userInfoBatch.isEmpty()) {
            return;
        }
        dao.updateUserInfoBatch(userInfoBatch);
    }

    @Override
    public WechatOfficialAccountUser selectOne(WeChatOaUserQueryDto oaUserDto) {
        WeChatOaUserQueryWq wq = new WeChatOaUserQueryWq();
        wq.setUnionid(oaUserDto.getUnionid());

        WechatOfficialAccountUser wechatOfficialAccountUser = dao.selectOne(wq);
        return wechatOfficialAccountUser;
    }
}
