package com.link.hub.pojo.mp.dto;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 抽奖活动配置实体类
 * @author lvbencai
 */
@Data
public class LotteryActivityRelDto {
    /**
     * 活动ID
     */
    private Long id;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 活动封面图URL
     */
    private String coverImg;

    /**
     * 活动开始时间
     */
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 活动状态：0-未开始 1-进行中 2-已结束 3-已下架
     */
//    private Integer status;

    /**
     * 活动规则（富文本）
     */
    private String ruleDesc;

    /**
     * 单用户最多参与次数（0=无限制）
     */
    private Integer maxParticipateNum;

    /**
     * 累计参与人数
     */
    private Long totalParticipate;


    /**
     * 关联活动ID
     */
    private Long activityId;

    /**
     * 关联用户ID
     */
    private Long userId;
    /**
     * 抽奖状态
     * 0-未参与 1-已参与（待开奖）   2-未中奖,  3-已中奖 4、未填写收获地址  5已填写-待发货 6已发货
     */
    private Integer lotteryStatus;

}
