package com.link.hub.domain.weChatOfficialAccount.entity;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.link.hub.pojo.oa.dto.WechatOaUserDto;
import com.link.hub.pojo.oa.dto.WechatOaUserResDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信公众号用户表 POJO/PO
 * 对应表：wechat_official_account_user
 */
@Data
@TableName("wechat_official_account_user")
public class WechatOfficialAccountUser implements Serializable {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     * 主键自增，匹配MySQL的AUTO_INCREMENT
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 公众号用户唯一标识
     */
    @TableField("openid") // 字段映射（若驼峰匹配可省略，此处显式标注更清晰）
    private String openid;

    /**
     * 微信开放平台统一标识
     */
    @TableField("unionid")
    private String unionid;

    /**
     * 用户昵称
     */
    @TableField("nickname")
    private String nickname;

    /**
     * 用户头像URL
     */
    @TableField("avatar_url")
    private String avatarUrl;

    /**
     * 性别：0-未知，1-男，2-女
     */
    @TableField("sex")
    private Integer sex;

    /**
     * 关注状态：1-已关注，0-已取消关注
     */
    @TableField("subscribe_status")
    private Integer subscribeStatus;

    /**
     * 关注时间
     */
    @TableField("subscribe_time")
    private Date subscribeTime;

    /**
     * 取消关注时间
     */
    @TableField("unsubscribe_time")
    private Date unsubscribeTime;

    /**
     * 公众号运营者给用户的备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 用户所在国家
     */
    @TableField("country")
    private String country;

    /**
     * 用户所在省份
     */
    @TableField("province")
    private String province;

    /**
     * 用户所在城市
     */
    @TableField("city")
    private String city;

    /**
     * 用户语言（zh-CN/zh-TW/en等）
     */
    @TableField("language")
    private String language;

    /**
     * 记录创建时间（MySQL默认CURRENT_TIMESTAMP）
     */
    private Date createTime;

    /**
     * 记录更新时间（MySQL默认ON UPDATE CURRENT_TIMESTAMP）
     */
    private Date updateTime;

    public static WechatOfficialAccountUser create(String openId) {
        WechatOfficialAccountUser wechatOfficialAccountUser = new WechatOfficialAccountUser();
        wechatOfficialAccountUser.setOpenid(openId);
        wechatOfficialAccountUser.setLanguage("zh_CN");
        return wechatOfficialAccountUser;
    }

    public static WechatOfficialAccountUser convert(WechatOaUserDto userDto) {
        WechatOfficialAccountUser user = new WechatOfficialAccountUser();
        user.setOpenid(userDto.getOpenid());
        user.setLanguage(userDto.getLanguage());
        return user;
    }

    public static WechatOfficialAccountUser convertByUserInfo(WechatOaUserResDto userInfo) {
        WechatOfficialAccountUser user = new WechatOfficialAccountUser();
        user.setOpenid(userInfo.getOpenid());

        user.setNickname(userInfo.getNickname());
        user.setAvatarUrl(userInfo.getHeadimgurl());
        user.setSex(userInfo.getSex());
        user.setCountry(userInfo.getCountry());
        user.setProvince(userInfo.getProvince());
        user.setCity(userInfo.getCity());

        user.setLanguage(userInfo.getLanguage());
        user.setSubscribeStatus(userInfo.getSubscribe());
        user.setSubscribeTime(ObjectUtil.isNotNull(userInfo.getSubscribeTime())?new Date(userInfo.getSubscribeTime() * 1000):null);
        user.setUnionid(userInfo.getUnionid());
        user.setRemark(userInfo.getRemark());
//        user.setGroupid(userInfo.getGroupid());
//        user.setTagidList(userInfo.getTagidList());

         return user;
    }
}
