package com.link.hub.domain.weChatMiniProgram.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.hub.domain.weChatMiniProgram.dao.WechatMiniProgramUserDao;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.domain.weChatMiniProgram.mapper.WechatMiniProgramUserMapper;
import com.link.hub.domain.weChatMiniProgram.wq.WechatMiniProgramUserWq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */
@Repository
public class WechatMiniProgramUserDaoImpl implements WechatMiniProgramUserDao {
    @Autowired
    WechatMiniProgramUserMapper wechatMiniProgramUserMapper;


    @Override
    public WechatMiniProgramUser queryMiniProgramUserOne(WechatMiniProgramUserWq wechatMiniProgramUserWq) {

        LambdaQueryWrapper<WechatMiniProgramUser> queryWrapper = new LambdaQueryWrapper<WechatMiniProgramUser>();
        queryWrapper.eq(ObjectUtil.isNotEmpty(wechatMiniProgramUserWq.getOpenid()),WechatMiniProgramUser::getOpenid, wechatMiniProgramUserWq.getOpenid());
        queryWrapper.eq(ObjectUtil.isNotEmpty(wechatMiniProgramUserWq.getUserId()),WechatMiniProgramUser::getId, wechatMiniProgramUserWq.getUserId());
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserMapper.selectOne(queryWrapper);
        return wechatMiniProgramUser;
    }

    @Override
    public void insert(WechatMiniProgramUser wechatMiniProgramUser) {
        wechatMiniProgramUserMapper.insert(wechatMiniProgramUser);
    }

    @Override
    public void updateById(WechatMiniProgramUser wechatMiniProgramUser) {
        wechatMiniProgramUserMapper.updateById(wechatMiniProgramUser);
    }
}
