package com.link.hub.controller.mp.query;

import com.alibaba.fastjson.JSONObject;
import com.link.hub.service.weChatMiniProgram.TencentMapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 腾讯地图接口控制器
 */
@RestController
@RequestMapping("/miniProgram/query")
public class TencentMapController {

    @Autowired
    private TencentMapService tencentMapService;

    /**
     * 经纬度→地理位置查询接口
     *
     * @param lat    纬度（必填）
     * @param lng    经度（必填）
     * @param getPoi 是否返回POI（可选，默认0）
     * @return 统一响应结果
     */
    @GetMapping("/geo/reverse")
    public JSONObject getLocationByLngLat(
            @RequestParam("lat") Double lat,
            @RequestParam("lng") Double lng,
            @RequestParam(value = "getPoi", defaultValue = "0") Integer getPoi) {
        JSONObject locationByLngLat = tencentMapService.getLocationByLngLat(lat, lng, getPoi);
        // 返回成功结果（可封装统一响应体，这里简化）
        return locationByLngLat;
    }
}
