package com.link.hub.controller.mp.query;

import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.pojo.mp.vo.MyLotteryVo;
import com.link.hub.service.weChatMiniProgram.LotteryActivityService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author : lvbencai
 * @date : 2025-12-10
 * @describe : 抽奖查询接口
 */
@RestController
@RequestMapping("/miniProgram/query/lottery")
public class LotteryQueryController {
    @Resource
    private LotteryActivityService lotteryActivityService;


    // 查询抽奖列表信息
    @RequestMapping("/list")
    public List<LotteryVo> list() {
        // 查询活动列表
        List<LotteryVo> lotteryVos = lotteryActivityService.queryList();
        return lotteryVos;
    }

    /**
     * 查询抽奖历史记录
      */
    @RequestMapping("/record")
    public List<MyLotteryVo> record() {
        // 查询活动列表
        List<MyLotteryVo> lotteryVos = lotteryActivityService.queryMyRecord();
        return lotteryVos;
    }
}
