package com.link.hub.service.weChatMiniProgram.impl;

import cn.hutool.core.date.DateUtil;
import com.link.hub.domain.weChatMiniProgram.dao.WechatMiniProgramUserDao;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.domain.weChatMiniProgram.wq.WechatMiniProgramUserWq;
import com.link.hub.pojo.mp.dto.MpOpenIdDTO;
import com.link.hub.pojo.mp.dto.MpUserDto;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 小程序用户服务实现
 */
@Slf4j
@Service
public class WechatMiniProgramUserServiceServiceImpl implements WechatMiniProgramUserService {

    @Resource
    private WechatMiniProgramUserDao wechatMiniProgramUserDao;

    /**
     * 查询小程序用户
     * @param mpUserDto
     * @return
     */
    @Override
    public WechatMiniProgramUser queryMiniProgramUserOne(MpUserDto mpUserDto) {
        WechatMiniProgramUserWq wechatMiniProgramUserWq = new WechatMiniProgramUserWq();
        wechatMiniProgramUserWq.setOpenid(mpUserDto.getOpenid());
        wechatMiniProgramUserWq.setUserId(mpUserDto.getId());
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserDao.queryMiniProgramUserOne(wechatMiniProgramUserWq);

        return wechatMiniProgramUser;
    }

    @Override
    public Long saveMiniProgramUser(MpOpenIdDTO mpOpenIdDTO) {
        WechatMiniProgramUser wechatMiniProgramUser = new WechatMiniProgramUser();
        wechatMiniProgramUser.setOpenid(mpOpenIdDTO.getOpenid());
        wechatMiniProgramUser.setUnionid(mpOpenIdDTO.getUnionid());
        wechatMiniProgramUser.setCreateTime(DateUtil.date());
        wechatMiniProgramUser.setUpdateTime(DateUtil.date());
        wechatMiniProgramUserDao.insert(wechatMiniProgramUser);
        return wechatMiniProgramUser.getId();
    }
}
