package com.link.hub.service.weChatMiniProgram.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.hub.domain.weChatMiniProgram.dao.LotteryParticipateDao;
import com.link.hub.domain.weChatMiniProgram.entity.LotteryParticipate;
import com.link.hub.domain.weChatMiniProgram.entity.WechatMiniProgramUser;
import com.link.hub.domain.weChatMiniProgram.enums.SourceEnum;
import com.link.hub.domain.weChatMiniProgram.mapper.LotteryParticipateMapper;
import com.link.hub.pojo.mp.dto.LotteryParticipateDto;
import com.link.hub.pojo.mp.dto.MpUserDto;
import com.link.hub.pojo.mp.vo.LotteryParticipateVo;
import com.link.hub.pojo.mp.vo.LotteryVo;
import com.link.hub.service.officeAccount.WechatOfficeAccountService;
import com.link.hub.service.weChatMiniProgram.LotteryParticipateService;
import com.link.hub.service.weChatMiniProgram.WechatMiniProgramUserService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户参与抽奖记录Service实现类
 */
@Service
public class LotteryParticipateServiceImpl extends ServiceImpl<LotteryParticipateMapper, LotteryParticipate>
        implements LotteryParticipateService {

    @Resource
    private LotteryParticipateDao lotteryParticipateDao;
    @Resource
    private WechatMiniProgramUserService wechatMiniProgramUserService;

    @Resource
    private WechatOfficeAccountService wechatOfficeAccountService;

    @Override
    public LotteryParticipate participateLottery(LotteryVo lotteryVo) {

        // 检验是否关注公众号
        MpUserDto mpUserDto = new MpUserDto();
        mpUserDto.setId(SecurityUtils.getUserId());
        WechatMiniProgramUser wechatMiniProgramUser = wechatMiniProgramUserService.queryMiniProgramUserOne(mpUserDto);
        // 根据用户id查询小程序的用户信息
        if (wechatMiniProgramUser == null) {
            throw new IllegalArgumentException("用户不存在");
        }
        String openid = wechatMiniProgramUser.getOpenid();
        if (!checkIsSubscribe(openid)) {
            throw new IllegalArgumentException("用户未关注公众号");
        }


        // 1. 校验是否已参与抽奖（防重）
        Long activityId = lotteryVo.getActivityId();
        Long userId = SecurityUtils.getUserId();
        if (lotteryParticipateDao.hasParticipated(activityId, userId)) {
            throw new IllegalArgumentException("用户已参与抽奖");
        }

        // 2. 创建参与记录
        LotteryParticipateDto dto =LotteryParticipateDto.create(lotteryVo);

        // 3. 保存记录（插入数据库）
        LotteryParticipate lotteryParticipate = lotteryParticipateDao.saveParticipate(dto);
        return lotteryParticipate;
    }

    @Override
    public boolean checkUserParticipated(Long activityId, Long userId) {
        return lotteryParticipateDao.checkUserParticipated(activityId, userId);
    }

    @Override
    public List<LotteryParticipateVo> getUserParticipateList(Long userId) {
        // 实现查询逻辑，获取用户参与记录 需要根据实际情况添加查询条件
        List<LotteryParticipate> participates = list();

        List<LotteryParticipateVo> vos = participates.stream()
                .map(participate -> {
                    LotteryParticipateVo vo = BeanUtils.transitionDto(participate, LotteryParticipateVo.class);
                    vo.setSourceName(SourceEnum.getSourceName(participate.getSource()));
                    return vo;
                }).collect(Collectors.toList());
        return vos;
    }

    @Override
    public int getUserParticipateCount(Long userId) {
        return lotteryParticipateDao.getUserParticipateCount(userId);
    }
    /**
     * 用户参与活动（核心业务逻辑）
     */




    private boolean checkIsSubscribe(String openid) {
        // 实现逻辑，检查用户是否已关注公众号
        wechatOfficeAccountService.isSubscribe(openid);
        return true;
    }
}
